package org.msh.tb.bd.tbforms.indicator.tb11;

import org.jboss.seam.annotations.In;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.bd.tbforms.query.tb11.TB11Block1Row;
import org.msh.tb.bd.tbforms.query.tb11.TB11Column;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.*;

import javax.persistence.EntityManager;
import java.util.List;
import java.util.Map;

/**
 * @author MSANTOS
 * Parent abstract class that contain all logic needed to generates the 3 tables for TB 11 Form Block 1
 */
public abstract class TBForm11Block1Home extends TBForm11 {

    @In(create=true) EntityManager entityManager;
    @In(create=true) Map<String, String> messages;

    /**
     * Initialized all cells on the report with the start value as 0
     */
    protected void createInterfaceFields(){
        for(TB11Block1Row r : TB11Block1Row.values()){
            for(TB11Column c : TB11Column.values()){
                addValue(c.name() + Gender.MALE.getAbbrev(), messages.get("manag.gender.male"), messages.get(r.getKey()), new Float(0));
                addValue(c.name() + Gender.FEMALE.getAbbrev(), messages.get("manag.gender.female"), messages.get(r.getKey()), new Float(0));
                if (c.isHasTotal()) {
                    addValue(c.name()+"T", messages.get("manag.pulmonary.sum"), messages.get(r.getKey()), new Float(0));
                }
            }
        }
    }

    protected void createIndicators() {
        TbFormQuery formQuery = getFormQuery();

        createInterfaceFields();

        Tbunit tbunit = getIndicatorFilters().getTbunitselection().getSelected();
        AdministrativeUnit adminUnit = getIndicatorFilters().getTbunitselection().getLastLevelAdminUnitSelected();

        List<Object[]> result = formQuery.queryDB(tbunit,
                adminUnit,
                getWorkspace(),
                getIndicatorFilters().getQuarter(),
                getEntityManager());

        for (Object[] o : result) {
            Integer sTB11ColumnOrdinal = (Integer) o[0];
            SuperColumn sTB11Column = SuperColumn.values()[sTB11ColumnOrdinal];

            switch(sTB11Column) {
                case TOTAL_REGISTERED:
                    loadTotalRegisteredTB11Columns(o);
                    break;
                case SUCCESSFULLY_TREATED_UNTIL_14:
                    loadSuccessTreatUntil14(o);
                    break;
                case SUCCESSFULLY_TREATED_AFTER_14:
                    loadSuccessTreatAfter14(o);
                    break;
                case OTHER_OUTCOMES:
                    loadOtherOutcomes(o);
                    break;
            }
        }
    }

    /**
     * Load value into Total Registered Super-TB11Column cells
     * @param result
     */
    private void loadTotalRegisteredTB11Columns(Object[] result){
        TB11Column column = TB11Column.TOTAL_REGISTERED;

        PatientType pt = (PatientType) result[1];
        PatientType prevPt = (PatientType) result[2];
        Gender g = (Gender) result[3];
        Long qtd = (Long) result[4];
        TB11Block1Row row = TB11Block1Row.getPatientTypeAsRow(pt.equals(PatientType.PREVIOUSLY_TREATED) ? prevPt : pt);

        // set value on specific row
        addValue(column.name() + g.getAbbrev(), messages.get(g.getKey()), messages.get(row.getKey()), qtd.floatValue());
        addValue(column.name() + "T", messages.get(g.getKey()), messages.get(row.getKey()), qtd.floatValue());

        // set value on specific row
        addValue(column.name() + g.getAbbrev(), messages.get(g.getKey()), messages.get(TB11Block1Row.TOTAL.getKey()), qtd.floatValue());
        addValue(column.name() + "T", messages.get(g.getKey()), messages.get(TB11Block1Row.TOTAL.getKey()), qtd.floatValue());

    }

    /**
     * Load value into Success Treatment until 14 years Super-TB11Column cells
     * @param result
     */
    private void loadSuccessTreatUntil14(Object[] result){
        TB11Column column = TB11Column.SUCCESSFULLY_TREATED_UNTIL_14;

        PatientType pt = (PatientType) result[1];
        PatientType prevPt = (PatientType) result[2];
        Gender g = (Gender) result[3];
        Long qtd = (Long) result[4];

        TB11Block1Row row = TB11Block1Row.getPatientTypeAsRow(pt.equals(PatientType.PREVIOUSLY_TREATED) ? prevPt : pt);

        setOutcomeValue(column, row, g, qtd);
    }

    /**
     * Load value into Success Treatment after 14 years Super-TB11Column cells
     * @param result
     */
    private void loadSuccessTreatAfter14(Object[] result){
        TB11Column column = TB11Column.SUCCESSFULLY_TREATED_AFTER_14;

        PatientType pt = (PatientType) result[1];
        PatientType prevPt = (PatientType) result[2];
        Gender g = (Gender) result[3];
        Long qtd = (Long) result[4];

        TB11Block1Row row = TB11Block1Row.getPatientTypeAsRow(pt.equals(PatientType.PREVIOUSLY_TREATED) ? prevPt : pt);

        setOutcomeValue(column, row, g, qtd);
    }

    /**
     * Load value into Outcome Super-TB11Column cells
     * @param result
     */
    private void loadOtherOutcomes(Object[] result){
        PatientType pt = (PatientType) result[1];
        PatientType prevPt = (PatientType) result[2];
        CaseState caseState = (CaseState) result[3];
        Gender g = (Gender) result[4];
        Long qtd = (Long) result[5];

        TB11Block1Row row = TB11Block1Row.getPatientTypeAsRow(pt.equals(PatientType.PREVIOUSLY_TREATED) ? prevPt : pt);
        TB11Column column = TB11Column.getStateAsColumn(caseState);

        setOutcomeValue(column, row, g, qtd);
    }

    /**
     * Set outcome value on table and its totals
     * @param column
     * @param row
     * @param g
     * @param qtd
     */
    private void setOutcomeValue(TB11Column column, TB11Block1Row row, Gender g, Long qtd) {
        // set value on specific row
        addValue(column.name() + g.getAbbrev(), messages.get(g.getKey()), messages.get(row.getKey()), qtd.floatValue());

        // set value on Grand Total column for specific row
        addValue(column.GRAND_TOTAL.name() + g.getAbbrev(), messages.get(g.getKey()), messages.get(row.getKey()), qtd.floatValue());
        addValue(column.GRAND_TOTAL.name() + "T", messages.get("manag.pulmonary.sum"), messages.get(row.getKey()), qtd.floatValue());

        // set value on specific row
        addValue(column.name() + g.getAbbrev(), messages.get(g.getKey()), messages.get(TB11Block1Row.TOTAL.getKey()), qtd.floatValue());

        // set value on Grand Total column for specific row
        addValue(column.GRAND_TOTAL.name() + g.getAbbrev(), messages.get(g.getKey()), messages.get(TB11Block1Row.TOTAL.getKey()), qtd.floatValue());
        addValue(column.GRAND_TOTAL.name() + "T", messages.get("manag.pulmonary.sum"), messages.get(TB11Block1Row.TOTAL.getKey()), qtd.floatValue());
    }

    /**
     * Returns the FormQuery used by the instance to get DB results
     * @return
     */
    protected abstract TbFormQuery getFormQuery();

}
